
/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Nov 6 2008
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version TLK_SCLK_ATP_menu.c#1:csrc:1
*  \author LironD
*  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
*           All Rights reserved
*/


/***** Include Files **************/
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Stdio.h"
#include "MW_ATP_UTIL_funcs.h"
#include "TLK_SCLK_ATP_Defines.h" 
#include "TLK_SCLK_TST_UTIL.h"
#include "TLK_SCLK_ATP_tests.h"
#include "TLK_SCLK_ATP_data.h"
#include "tlk_sclk_api_version.h"


/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_SCLK_Acceptance_ALL_TESTS      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs all the SCLK Acceptance tests.
*  
******************************************************************************/
DxError_t TST_ATP_TLK_SCLK_Acceptance_ALL_TESTS( void )
{
  /********* TST Variables Definitions ************/
  DxError_t          TST_Status = DX_SUCCESS, TST_TempError = DX_SUCCESS;

  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"************ Run All TLK SCLK ATP tests *************** \n"));      
  ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************* \n \n"));


  TST_Status = TST_ATP_TLK_SCLK_ServiceClkGenAndServiceClkRead();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TST_ATP_TLK_SCLK_ServiceClkRevalidation();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TLK_SCLK_ATP_Master_Clk_Update();
  TST_TempError = TST_TempError + TST_Status;

  TST_Status = TLK_SCLK_ATP_Authenticate();
  TST_TempError = TST_TempError + TST_Status;
  
  #ifdef SUPPORT_SLEEP
    TST_Status = TLK_SCLK_ATP_Service_Clk_Validity_Grace_Period();
    TST_TempError = TST_TempError + TST_Status;
  #endif
  
 
 /*Check if all tests pass*/
  if (TST_TempError != TST_PASS )
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!! ONE OR MORE OF THE ATP TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
    return TST_FAIL;
  }
  else
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n**************************************************************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"*** ALL OF THE TLK SCLK ATP  TESTS PASS    :)        **********************\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"******************************************************************\n"));

  }
  return TST_PASS;
}

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_TLK_SCLK_Run_All_Tests      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function init the master clock ,runs all the SCLK Acceptance tests 
*   and terminates the master clock.
*  
******************************************************************************/
DxError_t TST_ATP_TLK_SCLK_Run_All_Tests( void )
{
  /********* TST Variables Definitions ************/
  DxError_t         TST_Status = DX_SUCCESS, TST_TempError = DX_SUCCESS;

  TST_TempError = TLK_SCLK_TST_Init();
  TST_ATP_CHECK_ERROR_RETURN(TST_TempError,"TLK_SCLK_TST_Init_Tests","","");


  TST_TempError = TST_ATP_TLK_SCLK_Acceptance_ALL_TESTS();
  TST_ATP_CHECK_ERROR_RETURN(TST_TempError,"TST_ATP_TLK_SCLK_Acceptance_ALL_TESTS","","");
  
  TST_TempError = TLK_SCLK_TST_Terminate();
  TST_ATP_CHECK_ERROR_RETURN(TST_TempError,"TLK_SCLK_TST_Terminate","","");
  return TST_PASS;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }

}
/*****************************************************************************
* Function Name:                                                           
*  SCLK_TLK_ATP_menu      
*  
* Inputs:
*  None
*
* Outputs: 
*  None                                    
*
* Description:                                                                 
*  This function runs the ATP menu
*  
******************************************************************************/
DxError_t TLK_SCLK_ATP_menu (void)

{

  DxInt_t     Var;
  DxStatus    TST_TestStatus = DX_SUCCESS;
  DxError_t   TST_Status = DX_SUCCESS;
   
  TLK_SCLK_Version_t TST_Version;

 
  /* Init SST */
  TST_Status = TLK_SCLK_TST_Init();
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_SCLK_TST_Init","main","");


  TST_Status = TLK_SCLK_VersionGet(&TST_Version);

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_SCLK_VersionGet", "!!!!!!!!!", "!!!!!!!!!");

  ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----[Secured Time Clock Toolkit Version]----"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));
  ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n             %s %c.%d.%d.%d                   ",
                      TST_Version.tlk_sclk.componentName,
                      TST_Version.tlk_sclk.typeVer,
                      TST_Version.tlk_sclk.majorVer,
                      TST_Version.tlk_sclk.minorVer,
                      TST_Version.tlk_sclk.subVer));
  ATP_LOG_TST_PRINT((MW_ATP_MSG, "\n----------------------------------------------"));

     
  while(1)
  {
    while(1)
    {
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n\n\n              -- DISCRETIX LTD 2008 --           "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n       -- Secured Time Clock Toolkit Acceptance tests --       "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n--------------------------------------------------------------"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n-----------------------[ Main Tests Menu ]--------------------"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n--------------------------------------------------------------"));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [1] - Service Clock Generation And Verify Reading Test  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [2] - Service Clock Revalidation Test "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [3] - Master Clock Update Test "));
	   ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [4] - Service Clock Authenticate Test "));
       #ifdef SUPPORT_SLEEP
	         ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [5] - Service Clock Validity Grace Periode Test "));
       #endif
	   ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [T] - Run All Tests  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n [Z] - End Of Tests  "));
       ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n"));

      GET_NON_WHITE_SPACE_CHAR(Var);

      DX_VOS_Printf("\n Test = %c\n",Var);

      if (Var<='z')
        break;
      else
        DX_VOS_Printf("\n Error[%d]  Please select '1'-'XX'\n\n",Var);
    }

   
    switch(Var)
    {
    case '1':
      TST_ATP_TLK_SCLK_ServiceClkGenAndServiceClkRead();
      break;
    case '2':
      TST_ATP_TLK_SCLK_ServiceClkRevalidation();
      break;
    case '3':
      TLK_SCLK_ATP_Master_Clk_Update();
      break;
	case '4':
		TLK_SCLK_ATP_Authenticate();
		break;
    #ifdef SUPPORT_SLEEP
	case '5':
		TLK_SCLK_ATP_Service_Clk_Validity_Grace_Period();
		break;
	#endif
	case 'T':
      TST_ATP_TLK_SCLK_Acceptance_ALL_TESTS();
      break;
    }

    if(Var =='Z')
      break;
  }

  /* Terminate the secure clock toolkit */
  TST_Status = TLK_SCLK_TST_Terminate();
  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TLK_SCLK_TST_Terminate","main","");

  return 0;
  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}



